#!/usr/local/bin/perl

$quote_rep = '\\\'';		#in mSQL, a ' must be converted to a \' in order to be inserted in a field as a value
$back_slash_rep = '\\\\';	#in mSQL, a \ must be converted to a \\ in order to be inserted in a field as a value

$home_url 	= "http://\L$ENV{'SERVER_NAME'}\E";		#home URL
$root_path = $ENV{'DOCUMENT_ROOT'};					#UNIX root directory of your web site	
$dumppath = "$root_path/msql_keeper/dumpdata";   	#UNIX directory name that database backup text files are kept
$inputpath = "$root_path/msql_keeper/indata";   	#UNIX directory name that files to be imported are deposited 
$msql_keeper_url = "$home_url/msql_keeper";	    	#HTTP directory name that msql_keeper files are kept
$inputurl = "$msql_keeper_url/indata";      	 	#HTTP directory name that database backup text files are kept
$dumpurl  = "$msql_keeper_url/dumpdata";    	 	#HTTP directory name that database backup text files are kept

$database_file = "$root_path/msql_keeper/config/database.dat";
$new_fields_count = 5; 			#how many fields can be added to an existing table (from the add fields function)
$new_table_fields_count = 10; 	#how many fields can be added to a new table (from the create new table function)

%action_verbose=(	'select_db', 'Select Database',
					'from_text_final', 'Import Text File', 
					'from_text', 'Import Text File',
					'mod_fields', 'Modify Field Structure', 
					'mod_fields_final', 'Modify Field Structure', 
					'to_text', 'Export Table to Text File', 
					'to_text_final', 'Export Table to Text File', 
					'restore_db', 'Restore Database', 
					'dump_database','Dump Database',
					'add_data_final', 'Add Data', 
					'add_data', 'Add Data', 
					'view_info', 'View Table Information', 
					'create_table_final','Create New Table', 
					'create_table','Create New Table',
					'backup_table','Backup Table',
					'change_name','Rename Table',
					'add_fields','Add Fields',
					'add_fields_final','Add Fields', 
					'remove_fields','Remove Fields', 
					'remove_fields_final','Remove Fields', 
					'from_x_base','Import DBase File',
					'from_x_base_final','Import DBase File',
					'to_ansi_sql','Generate ANSI SQL Script',
					'drop_table','Delete Table',
					'query_table','Query Table',
					'query_table_final','Query Table'
					);

$anchors  = qq*<hr><center>\n*;
$anchors .= qq*<FONT SIZE=-1>\n*;
$anchors .= qq*[<a href="/msql_keeper/index.shtml">mSQL Keeper Main</a>]\n*;
$anchors .= qq*[<a href="/msql_keeper/table.shtml">Table Maint</a>]\n*;
$anchors .= qq*[<a href="/msql_keeper/db.shtml">Database Maint</a>]\n*;
$anchors .= qq*[<a href="/msql_keeper/impexp.shtml">Import/Export</a>]\n*;
$anchors .= qq*<br>[<a href="http://hughes.com.au/"><b>miniSQL Home</b></a>]\n*;
$anchors .= qq*<br><br>\n*;
$anchors .= qq*Written by <a href="mailto:chrislambrou\@internetmci.com">Chris Lambrou</a><br>\n*;
$anchors .= qq*<b>mSQL Keeper</b> is a Copyright of CGL Internet Services, Inc.(1997)<br>\n*;
$anchors .= qq*<b>miniSQL</b> is a Copyright of Hughes Technologies Pty. Ltd. (1996)\n*;
$anchors .= qq*</font>\n*;
$anchors .= qq*</center>\n*;

$new_name 			= qq*<INPUT TYPE="TEXT" NAME="new_name#" VALUE="" MAXLENGTH="20">*;
$new_type 			= qq*<SELECT NAME="type#"><OPTION VALUE=""><OPTION VALUE="1">INT\n<OPTION VALUE="2">CHAR\n<OPTION VALUE="3">REAL</SELECT>*;
$new_null 			= qq*<SELECT NAME="nulls#"><OPTION VALUE="0">Yes<OPTION VALUE="1">No\n</SELECT>*;
$new_len 			= qq*<INPUT TYPE="TEXT" NAME="length#" VALUE="" SIZE= "4" MAXLENGTH="4">*;
$new_primary_key 	= qq*<INPUT TYPE="radio" NAME="prim_key" VALUE="prim_key#">*;
$delete_box 		= qq*<INPUT TYPE="checkbox" NAME="delete#" VALUE="1">*;

$form_method = qq*<FORM METHOD="POST" ACTION="$msql_keeper_url/cgi/mk_main.cgi">*;
$excluded_tables = ""; #tables that you want to exclude from all database operations

$char_type_equality	= qq*
		<SELECT NAME="eq#">
			<OPTION VALUE="">
			<OPTION VALUE="=">=
			<OPTION VALUE="LIKE">LIKE
			<OPTION VALUE="gt">&gt;
			<OPTION VALUE="lt">&lt;
			<OPTION VALUE="gt=">&gt;=
			<OPTION VALUE="lt=">&lt;=
		</SELECT>*;

$number_type_equality = qq*
		<SELECT NAME="eq#">
			<OPTION VALUE="    ">
			<OPTION VALUE="=   ">=
			<OPTION VALUE="gt  ">&gt;
			<OPTION VALUE="lt  ">&lt;
			<OPTION VALUE="gt= ">&gt;=
			<OPTION VALUE="lt= ">&lt;=
		</SELECT>*;


$valid_names_text=<<__EO_VALIDNAMES__;
<h3>The mSQL manual states that:</h3>
A table or field name MUST begin with an alphabetic character. The
remainder of the name may be any of the following 63 characters: <p>
<ul>
    <li> A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
    <li> a b c d e f g h i j k l m n o p q r s t u v w x y z
    <li> 0 1 2 3 4 5 6 7 8 9
    <li> _ <i>(that's an &quot;underbar&quot; NOT a
    &quot;dash&quot;)</i>
</ul>
The maximum name length is set to 20 characters.<p>
In addition, the following are <i><b>mSQL reserved words</i></b> and therefore cannot be used as field or table names:
<pre>

	<, >=, <= , <>,=, >, by, on, distinct, desc, max, sequence, text,
	integer, clike, min, time, asc, like, null,
	not, count,	smallint, uint, avl, date, index,
	real,	money, avg,	step, unique, rlike, sum,
	update, all, char, drop, into, null, select, values,
	and, create, from, key, or, set, where,
	as, delete, insert, like, order, update,
	asc, desc, int, limit, primary, table

</pre>
<p>
__EO_VALIDNAMES__

@ReservedWords = ("<",">=", "by", "on",
				  "distinct", "desc", "max", "sequence", "text",
				  "integer", "clike", "min", "time", "asc", "like", "null",
				  "not", "count",	"smallint",	"uint", "avl", "date", "index",
				  "real",	"money", "avg",	"step", "unique", "rlike", "sum",
				  "update", "<=" ,"all", "char", "drop", "into", "null", "select", "values",
                  "<>","and", "create", "from", "key", "or", "set", "where",
                  "=", "as", "delete", "insert", "like", "order", "update",
                  ">", "asc", "desc", "int", "limit", "primary", "table");


$query_tips=<<__EO_QUERY_TIPS__;
Query Tips:<br>
<ul>
    <li> Table Fields: Select the fields you want to see in the query results (Ctrl+Click to select multiple).<br>
	     If no field is selected, all fields are returned.
    <li> Where Clause: Determines which records in the table will be returned.  For any fields that you want to include in 
		 the where clause, select a valid operator.	
    <li> Operators:<br>
		 For character fields, available operators are = , LIKE, &gt;, &lt;, =, &lt;=, &gt;= <br>
		 For number fields, available operators are &gt;, &lt;, =, &lt;=, &gt;= <br>
		 Check the <a href="http://Hughes.com.au/library/msql1/">msql Documentation</a> for further details on these operators.
    <li> <b>Table joins are not supported.(Sorry)</b>
	<li> <b>OR clauses are not supported.(Sorry again)</b><br>
		 AND is assumed if you include more that one fields in the WHERE clause.<br>
	     This is because the mSQL engine does not support parenthesis "(" and ")" in the WHERE clauses.<br>
		 This will be fixed in the upcoming <a href="http://Hughes.com.au/library/msql2/">version 2</a> of mSQL (now in beta).
</ul>
__EO_QUERY_TIPS__

$change_structure_warning=<<__EO_STRUCT_WARN__;
<h3><FONT COLOR = DARKRED><blink>Warning</blink></FONT><br>
Please be very careful when changing the field structure of a table.<br>
Specifically:</h3>
<ul>
    <li> If you change a field from CHAR to REAL or INT, 
	     then the data in the field will be coverted to Integers or real numbers.
		 <b><FONT COLOR = DARKRED>Any value that is not a valid numeric value will be converted to 0 (zero)</FONT></b>
	
	<li> If you reduce the length field of a CHAR field, say from 30 to 15, then <b><FONT COLOR = DARKRED>all field values will be truncated to the 
	     new length.</font></b>

</ul>
__EO_STRUCT_WARN__
1;
